#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define MAX_BUFFER 100
#define MAX_NAME_LEN 30
/* 
    no-mitigations:
    gcc -m32 -fno-stack-protector -U_FORTIFY_SOURCE -no-pie -Wl,-z,norelro -z execstack -O0 main.c -o validator

    Canary enabled:
    gcc -m32 -U_FORTIFY_SOURCE -no-pie -Wl,-z,norelro -z execstack -O0 main.c -o validator-canary

    nx-enabled:
    gcc -m32 -fno-stack-protector -U_FORTIFY_SOURCE -no-pie -Wl,-z,norelro -O0 main.c -o validator-nx

    PIE enabled:
    gcc -m32 -fno-stack-protector -U_FORTIFY_SOURCE -Wl,-z,norelro -z execstack -O0 main.c -o validator-pie

    RelRO enabled:
    gcc -m32 -fno-stack-protector -U_FORTIFY_SOURCE -no-pie -z execstack -O0 main.c -o validator-relro

    fortify:
    gcc -m32 -fno-stack-protector -D_FORTIFY_SOURCE=2 -no-pie -z execstack -Wl,-z,norelro -O2 main.c -o validator-fortify

    all:
    gcc -m32 -O0 main.c -o validator-all

*/

void lowcase(char* str) {
    while (*str) {
        *str = tolower(*str);
        str++;
    }
}

void check_candidate(char* name, int len) {
    char cname[MAX_NAME_LEN] = {0};
    char* candidates[5] = {"Tim", "Bob", "Tina", "Jimmy", "Rosy"};
    strncpy(cname, name, len );
    // lowcase the name
    char lower_name[MAX_NAME_LEN];
    strcpy(lower_name, cname);
    lowcase(lower_name);

    int found = 0;
    for (int i = 0; i < 5; i++) {
        // lowcase current student
        char lower_candidate[MAX_NAME_LEN] = {0};
        strncpy(lower_candidate, candidates[i], strlen(candidates[i]));
        lowcase(lower_candidate);

        if (strcmp(lower_name, lower_candidate) == 0) {
            found = 1;
            break;
        }
    }
    if (found) {
        printf("The name %s is in the candidate List.\n", cname);
    } else {
        printf("The name %s is not in the candidate List.\n", cname);
    }
}

int main (int argc, char** argv) {
    char buf[MAX_BUFFER] = {0};
    printf("[+] Are you a selected candidate? \n");
    printf("[+] Enter your name: ");
    fgets(buf, MAX_BUFFER, stdin);
    check_candidate(buf, (strlen(buf)-1));
}
